# SOULVPN - Application Root Deployment

## 🚀 Hızlı Başlangıç

### **1. Dosyaları Yükle**
Bu klasördeki tüm dosyaları shared hosting'inizin Application Root klasörüne yükleyin.

### **2. Environment Variables Ayarla**
`env-template.txt` dosyasını `.env` olarak kopyalayın ve değerleri düzenleyin:

```env
DB_HOST=localhost
DB_USER=your_username_soulvpn_db
DB_PASSWORD=your_password
DB_NAME=your_username_soulvpn_db
JWT_SECRET=your-secret-key
NEXTAUTH_URL=https://yourdomain.com
```

### **3. Veritabanı Kurulumu**
1. cPanel → MySQL Databases
2. Veritabanı oluştur: `soulvpn_db`
3. Kullanıcı oluştur ve veritabanına bağla
4. `database/schema.sql` dosyasını phpMyAdmin'de çalıştır

### **4. Dependencies Yükle**
```bash
npm install --production
```

### **5. Test Et**
- `https://yourdomain.com` → Ana sayfa
- Demo giriş: `ahmet@example.com` / `password`
- Admin giriş: `admin@example.com` / `password`

## 📁 Dosya Yapısı

```
Application Root/
├── .env                    # Environment variables
├── .htaccess              # Apache config
├── package.json           # Dependencies
├── server.js              # Next.js server
├── .next/                 # Next.js build files
├── node_modules/          # Dependencies
├── public/                # Static files
└── static files...        # Assets
```

## 🔧 Konfigürasyon

### **Shared Hosting Ayarları:**
- **Node.js Version**: 18+
- **Start Command**: `npm start`
- **App Directory**: Application Root path
- **SSL**: Let's Encrypt aktifleştir

### **Veritabanı:**
- **Host**: localhost
- **Port**: 3306
- **Charset**: utf8mb4
- **SSL**: Required (production)

## 🛡️ Güvenlik

### **Dosya İzinleri:**
```bash
chmod 755 /path/to/application/root
chmod 644 .env
chmod 644 .htaccess
```

### **SSL Kontrolü:**
- HTTPS aktif mi?
- Security headers çalışıyor mu?
- Mixed content var mı?

## 📊 Monitoring

### **Log Kontrolü:**
- Error logs: `/path/to/error.log`
- Application logs: `/path/to/app.log`

### **Performance:**
- cPanel → Metrics → Resource Usage
- CPU, Memory, Disk kullanımı
- Bandwidth kontrolü

## 🔄 Maintenance

### **Günlük:**
- Site erişilebilir mi?
- Database bağlantısı çalışıyor mu?
- Error logs temiz mi?

### **Haftalık:**
- Performance metrics
- Security updates
- Backup kontrolü

### **Aylık:**
- Resource usage analizi
- Cost optimization
- Feature updates

## 📞 Destek

### **Yaygın Sorunlar:**
1. **500 Error**: `.env` dosyasını kontrol et
2. **Database Connection**: Veritabanı bilgilerini kontrol et
3. **Permission Error**: Dosya izinlerini kontrol et
4. **Memory Limit**: `memory_limit` artır

### **Log Dosyaları:**
- Error logs: Hosting panelinde
- Application logs: `/path/to/logs/`
- Database logs: phpMyAdmin'de

## ✅ Deployment Checklist

- [ ] Dosyalar Application Root'a yüklendi
- [ ] .env dosyası yapılandırıldı
- [ ] Veritabanı oluşturuldu ve schema çalıştırıldı
- [ ] Dependencies yüklendi
- [ ] SSL aktifleştirildi
- [ ] Domain yapılandırıldı
- [ ] .htaccess ayarları yapıldı
- [ ] Test edildi
- [ ] Backup ayarlandı
- [ ] Monitoring aktifleştirildi

## 🎯 Sonuç

SOULVPN artık Application Root'ta çalışmaya hazır!

**Özellikler:**
- ✅ Production ready
- ✅ Shared hosting optimized
- ✅ MySQL integrated
- ✅ Security hardened
- ✅ Performance optimized
- ✅ Role-based access control
- ✅ Customer & Admin panels
- ✅ Support ticket system
- ✅ Order management
- ✅ VPN statistics

**Demo Kullanıcılar:**
- **Normal User**: `ahmet@example.com` / `password`
- **Admin User**: `admin@example.com` / `password`

---

**SOULVPN Team** - Your Own VPN Software 🚀
